<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="no"/>

	<!-- add empty paragraph if empty -->
	<xsl:template match="paste">
		<xsl:choose>
			<xsl:when test="not(* | text())">
				<div data-type="p">
					<span data-type="text"></span>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="*"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- ignore empty elements -->
	<xsl:template match="*[@data-type = 'p'] | *[@data-type = 'subheading']">
		<xsl:if test="normalize-space(.) != ''">
			<xsl:copy>
				<xsl:copy-of select="@*"/>
				<xsl:apply-templates select="*"/>
			</xsl:copy>
		</xsl:if>
	</xsl:template>

	<!-- add empty text to empty elements -->
	<xsl:template match="*[@data-type = 'bold'] | *[@data-type = 'italic'] | *[@data-type = 'underline'] | *[@data-type = 'subscript'] | *[@data-type = 'superscript'] | *[@data-type = 'link'] | *[@data-type = 'list_item'] | *[@data-type = 'tab_headcell'] | *[@data-type = 'tab_cell']">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:choose>
				<xsl:when test="not(* | text())">
					<span data-type="text"></span>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="*"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:copy>
	</xsl:template>

	<!-- copy -->
	<xsl:template match="node() | @*">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>