<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:svg="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" exclude-result-prefixes="math svg xlink" version="1.0">
	<xsl:output method="xml" omit-xml-declaration="yes" indent="no"/>

	<!-- non-mixed -->
	<xsl:template match="article | content | intro | strapline |  section | image-box | video-box | call-to-action | group | callout | teaser-list | testimonial-box">
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
	</xsl:template>

	<!-- mixed -->
	<xsl:template match="title | intro | strapline | subtitle | subheading | section | paragraph | pre | bold | italic | underline | subscript | superscript | footnote | marker">
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</div>
	</xsl:template>

	<xsl:template match="text">
		<div data-type="textel">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
	</xsl:template>

	<!-- non-mixed that may not be last child -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
		<xsl:if test="not(following-sibling::* | following-sibling::text())">
			<span data-type="text">&#8203;</span>
		</xsl:if>
	</xsl:template>
	-->

	<!-- mixed that may not be last child -->
	<xsl:template match="link">
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</div>
		<xsl:if test="not(following-sibling::* | following-sibling::text())">
			<span data-type="text"></span>
		</xsl:if>
	</xsl:template>

	<!-- mixed elements that should not be editable -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}" data-editable="false">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</div>
	</xsl:template>
	-->

	<!-- mixed elements that should not be removable -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}" data-removable="false">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</div>
	</xsl:template>
	-->

	<!-- mixed elements that should neither be editable nor removable -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}" data-editable="false" data-removable="false">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</div>
	</xsl:template>
	-->

	<!-- non-mixed elements that should not be editable -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}" data-editable="false">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
	</xsl:template>
	-->

	<!-- non-mixed elements that should not be removable -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}" data-removable="false">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
	</xsl:template>
	-->

	<!-- non-mixed elements that should neither be editable nor removable -->
	<!--
	<xsl:template match="">
		<div data-type="{local-name()}" data-editable="false" data-removable="false">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
	</xsl:template>
	-->

	<!-- empty -->
	<xsl:template match="new-page | hdivider">
		<xsl:if test="preceding-sibling::*[1][self::linebreak]">
			<span data-type="text">&#8203;</span>
		</xsl:if>
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
		</div>
	</xsl:template>

	<xsl:template match="anchor">
		<div data-type="{local-name()}" data-editable="false" data-removable="true">
			<xsl:apply-templates select="@*"/>
		</div>
	</xsl:template>


	<xsl:template match="linebreak">
		<xsl:if test="preceding-sibling::*[1][self::linebreak]">
			<span data-type="text"></span>
		</xsl:if>
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
		</div>
	</xsl:template>

	<!-- list -->
	<xsl:template match="bullet-list">
		<ul data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</ul>
	</xsl:template>

	<xsl:template match="enumeration">
		<ol data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</ol>
	</xsl:template>

	<xsl:template match="item">
		<li data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</li>
	</xsl:template>

	<!-- media -->
	<xsl:template match="video | poster | audio">
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
		</div>
	</xsl:template>

	<!-- table html -->
	<xsl:template match="table">
		<table data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="table-caption"/>
			<xsl:choose>
				<xsl:when test="colspec">
					<xsl:apply-templates select="colspec"/>
				</xsl:when>
				<xsl:when test="col">
					<colgroup data-type="colspec">
						<xsl:apply-templates select="col"/>
					</colgroup>
				</xsl:when>
				<xsl:otherwise>
					<colgroup data-type="colspec">
						<xsl:for-each select=".//tr[1]/*">
							<xsl:choose>
								<xsl:when test="@colspan and number(@colspan) = number(@colspan)">
									<xsl:call-template name="col">
										<xsl:with-param name="index" select="1"/>
										<xsl:with-param name="count" select="@colspan"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<col data-type="col"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</colgroup>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>

	<xsl:template match="table-caption">
		<caption data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</caption>
	</xsl:template>

	<xsl:template match="colspec">
		<colgroup data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</colgroup>
	</xsl:template>

	<xsl:template match="col">
		<col data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</col>
	</xsl:template>

	<xsl:template name="col">
		<xsl:param name="index"/>
		<xsl:param name="count"/>

		<col data-type="col"/>

		<xsl:if test="not($index = $count)">
			<xsl:call-template name="col">
				<xsl:with-param name="index" select="$index + 1"/>
				<xsl:with-param name="count" select="$count"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template match="THEAD">
		<thead data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</thead>
	</xsl:template>

	<xsl:template match="tbody">
		<tbody data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</tbody>
	</xsl:template>

	<xsl:template match="TFOOT">
		<tfoot data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</tfoot>
	</xsl:template>

	<xsl:template match="row">
		<tr data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</tr>
	</xsl:template>

	<xsl:template match="TH">
		<th data-type="{local-name()}" colspan="{@colspan}" rowspan="{@rowspan}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</th>
	</xsl:template>

	<xsl:template match="cell">
		<td data-type="{local-name()}" colspan="{@colspan}" rowspan="{@rowspan}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
			<xsl:if test="not(* | text())">
				<span data-type="text"></span>
			</xsl:if>
		</td>
	</xsl:template>

	<!-- table cals -->
	<!--
	<xsl:template match="table | title">
		<div data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</div>
	</xsl:template>

	<xsl:template match="tgroup">
		<table data-type="{local-name()}">
			<xsl:apply-templates select="@*[local-name() != 'cols']"/>
			<colgroup data-type="colgroup">
				<xsl:call-template name="generateCols">
					<xsl:with-param name="colCount" select="@cols"/>
				</xsl:call-template>
			</colgroup>
			<xsl:apply-templates select="thead | tfoot"/>
			<xsl:apply-templates select="tbody"/>
		</table>
	</xsl:template>

	<xsl:template match="thead">
		<thead data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</thead>
	</xsl:template>

	<xsl:template match="tbody">
		<tbody data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</tbody>
	</xsl:template>

	<xsl:template match="tfoot">
		<tfoot data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</tfoot>
	</xsl:template>

	<xsl:template match="row">
		<tr data-type="{local-name()}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</tr>
	</xsl:template>

	<xsl:template match="entry">
		<td data-type="{local-name()}">
			<xsl:choose>
				<xsl:when test="@spanname">
					<xsl:variable name="nameSt" select="ancestor::tgroup/spanspec[@spanname = ./@spanname]/@namest"/>
					<xsl:variable name="nameEnd" select="ancestor::tgroup/spanspec[@spanname = ./@spanname]/@nameend"/>
					<xsl:variable name="colSt" select="ancestor::*[colspec/@colname = $nameSt]/colspec[@colname = $nameSt]/@colnum"/>
					<xsl:variable name="colEnd" select="ancestor::*[colspec/@colname = $nameEnd]/colspec[@colname = $nameEnd]/@colnum"/>
					<xsl:variable name="colSpan"><xsl:value-of select="number($colEnd) - number($colSt) + 1"/></xsl:variable>
					<xsl:attribute name="colspan"><xsl:value-of select="$colSpan"/></xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan"><xsl:value-of select="$colSpan"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="@namest">
					<xsl:variable name="colSpan">
						<xsl:call-template name="calculateColSpan"/>
					</xsl:variable>
					<xsl:attribute name="colspan"><xsl:value-of select="$colSpan"/></xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan"><xsl:value-of select="$colSpan"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="colspan">1</xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan">1</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@morerows">
					<xsl:attribute name="rowspan"><xsl:value-of select="@morerows + 1" /></xsl:attribute>
					<xsl:attribute name="data-attrvalue-rowspan"><xsl:value-of select="@morerows + 1" /></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="rowspan">1</xsl:attribute>
					<xsl:attribute name="data-attrvalue-rowspan">1</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:apply-templates select="@*[local-name() != 'colname' and local-name() != 'namest' and local-name() != 'nameend' and local-name() != 'morerows']"/>

			<xsl:apply-templates select="* | comment() | processing-instruction()"/>
		</td>
	</xsl:template>

	<xsl:template name="generateCols">
		<xsl:param name="colCount" select="1"/>
		<xsl:param name="currentIndex" select="1"/>

		<xsl:choose>
			<xsl:when test="$colCount &lt; $currentIndex"/>
			<xsl:otherwise>
				<xsl:call-template name="generateCol">
					<xsl:with-param name="colIndex" select="$currentIndex"/>
				</xsl:call-template>
				<xsl:call-template name="generateCols">
					<xsl:with-param name="colCount" select="$colCount"/>
					<xsl:with-param name="currentIndex" select="$currentIndex + 1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="generateCol">
		<xsl:param name="colIndex" select="1"/>
		<xsl:param name="colSpecs" select="./colspec"/>
		<xsl:param name="count" select="1"/>
		<xsl:param name="colNum" select="1"/>

		<xsl:choose>
			<xsl:when test="$count > count($colSpecs)">
				<col data-type="colspec"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="colSpec" select="$colSpecs[$count = position()]"/>
				<xsl:variable name="colSpecColNum">
					<xsl:choose>
						<xsl:when test="$colSpec/@colnum">
							<xsl:value-of select="$colSpec/@colnum"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$colNum"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:choose>
					<xsl:when test="$colSpecColNum = $colIndex">
						<col data-type="colspec">
							<xsl:apply-templates select="$colSpec/@*[local-name() != 'colnum' and local-name() != 'colname']"/>
						</col>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="generateCol">
							<xsl:with-param name="colIndex" select="$colIndex" />
							<xsl:with-param name="colSpecs" select="$colSpecs" />
							<xsl:with-param name="count" select="$count + 1" />
							<xsl:with-param name="colNum">
								<xsl:choose>
									<xsl:when test="$colSpec/@colnum">
										<xsl:value-of select="$colSpec/@colnum + 1" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$colNum + 1" />
									</xsl:otherwise>
								</xsl:choose>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="cellColnum">
		<xsl:param name="cell" select="."/>

		<xsl:choose>
			<xsl:when test="$cell/@colname">
				<xsl:variable name="colName" select="$cell/@colname"/>
				<xsl:variable name="colSpec" select="$cell/ancestor::tgroup/colspec[@colname = $colName]"/>

				<xsl:call-template name="colSpecColNum">
					<xsl:with-param name="colSpec" select="$colSpec"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$cell/@namest">
				<xsl:variable name="nameSt" select="$cell/@namest"/>
				<xsl:variable name="colSpec" select="$cell/ancestor::tgroup/colspec[@colname = $nameSt]"/>

				<xsl:call-template name="colSpecColNum">
					<xsl:with-param name="colSpec" select="$colSpec"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="count($cell/preceding-sibling::*) = 0">1</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="prevCol">
					<xsl:call-template name="cellEndingColNum">
						<xsl:with-param name="cell" select="$cell/preceding-sibling::*[1]"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$prevCol + 1"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="cellEndingColNum">
		<xsl:param name="cell" select="."/>

		<xsl:choose>
			<xsl:when test="$cell/@colname">
				<xsl:variable name="colName" select="$cell/@colname"/>
				<xsl:variable name="colSpec" select="$cell/ancestor::tgroup/colspec[@colname = $colName]"/>

				<xsl:call-template name="colSpecColNum">
					<xsl:with-param name="colSpec" select="$colSpec"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$cell/@nameend">
				<xsl:variable name="nameEnd" select="$cell/@nameend"/>
				<xsl:variable name="colSpec" select="$cell/ancestor::tgroup/colspec[@colname = $nameEnd]"/>

				<xsl:call-template name="colSpecColNum">
					<xsl:with-param name="colSpec" select="$colSpec"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="count($cell/preceding-sibling::*) = 0">1</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="prevCol">
					<xsl:call-template name="cellEndingColNum">
						<xsl:with-param name="cell" select="$cell/preceding-sibling::*[1]"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$prevCol + 1"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="colSpecColNum">
		<xsl:param name="colSpec" select="."/>

		<xsl:choose>
			<xsl:when test="$colSpec/@colnum">
				<xsl:value-of select="$colSpec/@colnum"/>
			</xsl:when>
			<xsl:when test="$colSpec/preceding-sibling::colspec">
				<xsl:variable name="prevColSpecColNum">
					<xsl:call-template name="colSpecColNum">
						<xsl:with-param name="colSpec" select="$colSpec/preceding-sibling::colspec[1]"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$prevColSpecColNum + 1"/>
			</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="calculateColSpan">
		<xsl:param name="cell" select="."/>

		<xsl:variable name="nameSt" select="$cell/@namest"/>
		<xsl:variable name="nameEnd" select="$cell/@nameend"/>

		<xsl:variable name="startCol">
			<xsl:call-template name="colSpecColNum">
				<xsl:with-param name="colSpec" select="$cell/ancestor::tgroup/colspec[@colname = $nameSt]"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="endCol">
			<xsl:call-template name="colSpecColNum">
				<xsl:with-param name="colSpec" select="$cell/ancestor::tgroup/colspec[@colname = $nameEnd]"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:value-of select="$endCol - $startCol + 1"/>
	</xsl:template>
	-->

	<!-- marker -->
	<xsl:template match="processing-instruction('xe-comment_mark_start')">
		<span
				id="xe-marker-start-{substring-before(substring-after(., 'id=&quot;'), '&quot;')}"
				data-id="{substring-before(substring-after(., 'id=&quot;'), '&quot;')}"
				data-type="marker-start-comment"
				data-dataname-guidstart="guidStart"
				data-datavalue-guidstart="{substring-before(substring-after(., 'guid=&quot;'), '&quot;')}"
				data-dataname-author="author"
				data-datavalue-author="{substring-before(substring-after(., 'author=&quot;'), '&quot;')}"
				data-dataname-time="time"
				data-datavalue-time="{substring-before(substring-after(., 'time=&quot;'), '&quot;')}"
				data-dataname-text="text"
				data-datavalue-text="{substring-before(substring-after(., 'text=&quot;'), '&quot;')}"
				data-dataname-replies="replies"
				data-datavalue-replies="{substring-before(substring-after(., 'replies=&quot;'), '&quot;')}"
				data-dataname-seenby="seenBy"
				data-datavalue-seenby="{substring-before(substring-after(., 'seenby=&quot;'), '&quot;')}"/>
	</xsl:template>

	<xsl:template match="processing-instruction('xe-comment_mark_end')">
		<span
				id="xe-marker-end-{substring-before(substring-after(., 'id=&quot;'), '&quot;')}"
				data-id="{substring-before(substring-after(., 'id=&quot;'), '&quot;')}"
				data-dataname-guidend="guidEnd"
				data-datavalue-guidend="{substring-before(substring-after(., 'guid=&quot;'), '&quot;')}"
				data-type="marker-end-comment"/>
	</xsl:template>

	<!-- processing instructions -->
	<xsl:template match="processing-instruction()">
		<xsl:copy/>
	</xsl:template>

	<!-- comments -->
	<xsl:template match="comment()">
		<xsl:copy/>
	</xsl:template>

	<!-- text -->
	<xsl:template match="text()">
		<xsl:choose>
			<xsl:when test="string-length(translate(., ' ','')) = 0">
				<span data-type="text">&#160;<xsl:value-of select="substring-after(., ' ')"/></span>
			</xsl:when>
			<xsl:otherwise>
				<span data-type="text"><xsl:value-of select="."/></span>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- attribute -->
	<xsl:template match="@*" priority="1.0">
		<xsl:attribute name="data-attrvalue-{local-name()}"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@xlink:href" priority="5.0">
		<xsl:attribute name="data-attrvalue-xlink_href"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@xlink:role" priority="5.0">
		<xsl:attribute name="data-attrvalue-xlink_role"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<!-- unknown -->
	<xsl:template match="*">
		<div data-type="{local-name()}" class="xe-unknown">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="node()"/>
		</div>
	</xsl:template>

	<!-- copy -->
	<xsl:template match="node() | @*" mode="copy">
		<xsl:copy>
			<xsl:apply-templates select="node() | @*" mode="copy"/>
		</xsl:copy>
	</xsl:template>

	<!-- dummy element for page break marker -->
	<xsl:template match="processing-instruction('pagebreak')">
		<div data-type="datamining_pagebreak"></div>
	</xsl:template>
</xsl:stylesheet>