<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0">
	<xsl:output method="xml" indent="no"/>
	<xsl:preserve-space elements="pre" />

	<!-- text -->
	<xsl:template match="*[@data-type = 'text']">
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="*[@data-type = 'pre']/*[@data-type = 'text']" priority="2.0">
		<xsl:apply-templates select="text()" mode="addLineBreaks"/>
	</xsl:template>

	<!-- restore names that have been reserved by JS / Xe -->
	<xsl:template match="*[@data-type = 'textel']">
		<xsl:element name="text">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*[@data-type = 'subheadline1']">
		<xsl:element name="subheadline-1">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*[@data-type = 'subheadline2']">
		<xsl:element name="subheadline-2">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*[@data-type = 'subheadline3']">
		<xsl:element name="subheadline-3">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*[@data-type = 'bulletlist']">
		<xsl:element name="bullet-list">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*[@data-type = 'videobox']">
		<xsl:element name="video-box">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*[@data-type = 'imagebox']">
		<xsl:element name="image-box">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*[@data-type = 'bolditalic']">
		<xsl:element name="bold-italic">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<!-- Table -->
	<xsl:template match="*[@data-type = 'tbody_dummy']">
		<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
	</xsl:template>

	<!-- default attribute -->
	<xsl:template match="@*">
		<xsl:if test="starts-with(local-name(), 'data-attrvalue-')">
			<xsl:variable name="key" select="substring-after(local-name(), 'data-attrvalue-')"/>
			<!--xsl:if test="parent::*/@*[local-name() = concat('data-attrname-', $key)]">
				<xsl:variable name="realname" select="parent::*/@*[local-name() = concat('data-attrname-', $key)]"/>
				<xsl:attribute name="{$realname}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:if-->
			<xsl:choose>
				<xsl:when test="parent::*/@*[local-name() = concat('data-attrname-', $key)]">
					<xsl:variable name="realname" select="parent::*/@*[local-name() = concat('data-attrname-', $key)]"/>
					<xsl:attribute name="{$realname}"><xsl:value-of select="."/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="{$key}"><xsl:value-of select="."/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<!--xsl:if test="starts-with(local-name(), 'data-attrvalue-')">
			<xsl:variable name="key" select="substring-after(local-name(), 'data-attrvalue-')"/>
			<xsl:variable name="realname" select="parent::*/@*[local-name() = concat('data-attrname-', $key)]"/>
			<xsl:choose >
				<xsl:when test="$realname!=''">
					<xsl:attribute name="{$realname}"><xsl:value-of select="."/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="valueOfKey">
						<xsl:value-of select="parent::*/@*[concat('data-attrname-', $key)]"/>
					</xsl:variable>
					<xsl:attribute name="{$valueOfKey}"><xsl:value-of select="."/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if-->
	</xsl:template>

	<!-- restore namespaces -->
	<xsl:template match="@data-attrvalue-xlink_href" priority="5.0">
		<xsl:attribute name="xlink:href"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-xlink_role"  priority="5.0">
		<xsl:attribute name="xlink:role"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-assetid"  priority="5.0">
		<xsl:attribute name="asset-id"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-urlfragment"  priority="5.0">
		<xsl:attribute name="url-fragment"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-seotitle"  priority="5.0">
		<xsl:attribute name="seo-title"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-aspectratio"  priority="5.0">
		<xsl:attribute name="aspect-ratio"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-alttex"  priority="5.0">
		<xsl:attribute name="alt-tex"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-placementcategory"  priority="5.0">
		<xsl:attribute name="placement-category"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-displayimagecaptions"  priority="5.0">
		<xsl:attribute name="display-image-captions"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-codetype"  priority="5.0">
		<xsl:attribute name="code-type"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-startslide"  priority="5.0">
		<xsl:attribute name="start-slide"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-table-of-contentsexclude"  priority="5.0">
		<xsl:attribute name="table-of-contents-exclude"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-headerrowcount"  priority="5.0">
		<xsl:attribute name="header-row-count"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<xsl:template match="@data-attrvalue-footerrowcount"  priority="5.0">
		<xsl:attribute name="footer-row-count"><xsl:value-of select="."/></xsl:attribute>
	</xsl:template>

	<!-- marker -->
	<xsl:template match="*[@data-type = 'marker-start-comment'] | *[@data-type = 'marker-start-commentCurrent'] | *[@data-type = 'marker-start-commentRead']">
		<xsl:processing-instruction name="xe-comment_mark_start">
			<xsl:text>id="</xsl:text><xsl:value-of select="@data-id"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>guid="</xsl:text><xsl:value-of select="@data-datavalue-guidstart"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>author="</xsl:text><xsl:value-of select="@data-datavalue-author"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>time="</xsl:text><xsl:value-of select="@data-datavalue-time"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>text="</xsl:text><xsl:value-of select="@data-datavalue-text"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>replies="</xsl:text><xsl:value-of select="@data-datavalue-replies"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>seenby="</xsl:text><xsl:value-of select="@data-datavalue-seenby"/><xsl:text>"</xsl:text>
		</xsl:processing-instruction>
	</xsl:template>

	<xsl:template match="*[@data-type = 'marker-end-comment'] | *[@data-type = 'marker-end-commentCurrent'] | *[@data-type = 'marker-end-commentRead']">
		<xsl:processing-instruction name="xe-comment_mark_end">
			<xsl:text>id="</xsl:text><xsl:value-of select="@data-id"/><xsl:text>"</xsl:text>
			<xsl:text> </xsl:text>
			<xsl:text>guid="</xsl:text><xsl:value-of select="@data-datavalue-guidend"/><xsl:text>"</xsl:text>
		</xsl:processing-instruction>
	</xsl:template>

	<!-- processing instructions -->
	<xsl:template match="processing-instruction()">
		<xsl:copy/>
	</xsl:template>

	<!-- comments -->
	<xsl:template match="comment()">
		<xsl:copy/>
	</xsl:template>

	<!-- default tag -->
	<xsl:template match="*[@data-type]" priority="-9">
		<xsl:element name="{@data-type}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="*[@data-type] | comment() | processing-instruction()"/>
		</xsl:element>
	</xsl:template>

	<!-- Handle linebreaks  -->
	<xsl:template match="text()" mode="addLineBreaks">
		<xsl:call-template name="tokenizeLineBreak">
			<xsl:with-param name="text" select="."/>
		</xsl:call-template>
	</xsl:template>


	<xsl:template name="tokenizeLineBreak">
		<xsl:param name="text"/>
		<xsl:choose>
			<xsl:when test="not(contains($text, '&#10;'))">
				<xsl:value-of select="$text"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring-before($text, '&#10;')"/>
				<xsl:element name="linebreak"/>
				<xsl:call-template name="tokenizeLineBreak">
					<xsl:with-param name="text" select="substring-after($text, '&#10;')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>