<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				version="1.0">
	<xsl:output method="xml" indent="no"/>

	<!-- ignore head element -->
	<xsl:template match="html">
		<paste>
			<xsl:apply-templates select="body"/>
		</paste>
	</xsl:template>

	<!-- structure/mixed -->
	<xsl:template match="body">
		<xsl:copy>
			<xsl:apply-templates select="p | span | div | h1 | h2 | h3 | h4 | h5 | h6 | ul | ol | table | text()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="body/p">
		<xsl:choose>
			<xsl:when test="contains(@style, 'mso-list')">
				<xsl:if test="not(preceding-sibling::p[1][contains(@style, 'mso-list')])">
					<xsl:variable name="firstAfterList" select="generate-id(following-sibling::p[not(contains(@style, 'mso-list'))][1])"/>
					<ul>
						<xsl:choose>
							<xsl:when test="*[contains(@style, 'Symbol')]">
								<xsl:attribute name="data-type">list_unordered</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="data-type">list_ordered</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<li data-type="list_item">
							<xsl:apply-templates select="br | sub[not(.//span[contains(@style, 'Ignore')])] | sup[not(.//span[contains(@style, 'Ignore')])] | a[not(.//span[contains(@style, 'Ignore')])] | b[not(.//span[contains(@style, 'Ignore')])] | i[not(.//span[contains(@style, 'Ignore')])] | u[not(.//span[contains(@style, 'Ignore')])] | span[not(.//span[contains(@style, 'Ignore')])] | text() | ./*[not(self::sub | self::sup | self::a | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
						</li>
						<xsl:for-each select="following-sibling::p[contains(@style, 'mso-list') and not(preceding-sibling::p[generate-id(.) = $firstAfterList])]">
							<li data-type="list_item">
								<xsl:apply-templates select="br | sub[not(.//span[contains(@style, 'Ignore')])] | sup[not(.//span[contains(@style, 'Ignore')])] | a[not(.//span[contains(@style, 'Ignore')])] | b[not(.//span[contains(@style, 'Ignore')])] | strong[not(.//span[contains(@style, 'Ignore')])] | i[not(.//span[contains(@style, 'Ignore')])] | u[not(.//span[contains(@style, 'Ignore')])] | span[not(.//span[contains(@style, 'Ignore')])] | text() | ./*[not(self::sub | self::sup | self::a | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
							</li>
						</xsl:for-each>
					</ul>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div data-type="p">
					<xsl:apply-templates select="br | sub | sup | a | b | strong | i | u | span | text() | ./*[not(self::sub | self::sup | self::a | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="html/body/div | html/body/span">
		<div data-type="p">
			<xsl:apply-templates select="br | sub | sup | a | b | strong | i | u | span | text() | ./*[not(self::sub | self::sup | self::a | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</div>
	</xsl:template>

	<xsl:template match="p | div">
		<xsl:apply-templates select="br | sub | sup | a | b | strong | i | u | span | text() | ./*[not(self::sub | self::sup | self::a | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
	</xsl:template>

	<xsl:template match="span">
		<xsl:apply-templates select="sub | sup | a | b | strong | i | u | span | text() | ./*[not(self::sub | self::sup | self::a | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
	</xsl:template>

	<xsl:template match="br">
		<xsl:if test="not(preceding-sibling::node()) or preceding-sibling::node()[1][self::br]">
			<span data-type="text"></span>
		</xsl:if>
		<span data-type="linebreak"/>
		<xsl:if test="not(following-sibling::node())">
			<span data-type="text"></span>
		</xsl:if>
	</xsl:template>

	<xsl:template match="h1 | h2 | h3 | h4 | h5 | h6">
		<div data-type="subheading">
			<xsl:apply-templates select=".//text()"/>
		</div>
	</xsl:template>

	<!-- list -->
	<xsl:template match="ul">
		<ul data-type="list_unordered">
			<xsl:apply-templates select="li"/>
		</ul>
	</xsl:template>

	<xsl:template match="ol">
		<ul data-type="list_ordered">
			<xsl:apply-templates select="li"/>
		</ul>
	</xsl:template>

	<xsl:template match="li">
		<li data-type="list_item">
			<xsl:apply-templates select="sub | sup | a | p | b | strong | i | u | span | text() | ./*[not(self::sub | self::sup | self::a | self::p | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</li>
	</xsl:template>

	<!-- inline -->
	<xsl:template match="b | strong">
		<span data-type="bold">
			<xsl:apply-templates select="sub | sup | i | u | span | text() | ./*[not(self::sub | self::sup | self::i | self::u | self::span)]//text()"/>
		</span>
	</xsl:template>

	<xsl:template match="i">
		<span data-type="italic">
			<xsl:choose>
				<xsl:when test="contains(@style, 'font-weight: bold')">
					<span data-type="bold">
						<xsl:apply-templates select="sub | sup | b | strong | u | span | text() | ./*[not(self::sub | self::sup | self::b | self::strong | self::u | self::span)]//text()"/>
					</span>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="sub | sup | b | strong | u | span | text() | ./*[not(self::sub | self::sup | self::b | self::strong | self::u | self::span)]//text()"/>
				</xsl:otherwise>
			</xsl:choose>
		</span>
	</xsl:template>

	<xsl:template match="u | span[contains(@style, 'text-decoration: underline')]">
		<span data-type="underline">
			<xsl:apply-templates select="sub | sup | b | strong | i | span | text() | ./*[not(self::sub | self::sup | self::b | self::strong | self::i | self::span)]//text()"/>
		</span>
	</xsl:template>

	<xsl:template match="sub">
		<span data-type="subscript">
			<xsl:apply-templates select="sup | b | strong | i | u | span | text() | ./*[not(self::sup | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</span>
	</xsl:template>

	<xsl:template match="sup">
		<span data-type="superscript">
			<xsl:apply-templates select="sub | b | strong | i | u | span | text() | ./*[not(self::sub | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</span>
	</xsl:template>

	<xsl:template match="a">
		<span data-type="link" data-attrvalue-href="{@href}">
			<xsl:choose>
				<xsl:when test="@title">
					<xsl:attribute name="data-attrvalue-title"><xsl:value-of select="@title"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="data-attrvalue-title"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@target">
					<xsl:attribute name="data-attrvalue-target"><xsl:value-of select="@target"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="data-attrvalue-target">_self</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="sub | sup | b | strong | i | u | span | text() | ./*[not(self::sub | self::sup | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</span>
	</xsl:template>

	<!-- table -->
	<xsl:template match="table">
		<table data-type="tab_table">
			<xsl:choose>
				<xsl:when test="tbody">
					<xsl:apply-templates select="tbody"/>
				</xsl:when>
				<xsl:otherwise>
					<tbody data-type="tab_body">
						<xsl:apply-templates select="tr"/>
					</tbody>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>

	<xsl:template match="tbody">
		<tbody data-type="tab_body">
			<xsl:apply-templates select="tr"/>
		</tbody>
	</xsl:template>

	<xsl:template match="tr">
		<tr data-type="tab_row">
			<xsl:apply-templates select="th | td"/>
		</tr>
	</xsl:template>

	<xsl:template match="th">
		<th data-type="tab_headcell" data-attrvalue-align="left">
			<xsl:choose>
				<xsl:when test="@colspan">
					<xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="colspan">1</xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan">1</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@rowspan">
					<xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute>
					<xsl:attribute name="data-attrvalue-rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="rowspan">1</xsl:attribute>
					<xsl:attribute name="data-attrvalue-rowspan">1</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="br | a | p | b | strong | i | u | span | text() | ./*[not(self::a | self::p | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</th>
	</xsl:template>

	<xsl:template match="td">
		<td data-type="tab_cell" data-attrvalue-align="left">
			<xsl:choose>
				<xsl:when test="@colspan">
					<xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="colspan">1</xsl:attribute>
					<xsl:attribute name="data-attrvalue-colspan">1</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@rowspan">
					<xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute>
					<xsl:attribute name="data-attrvalue-rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="rowspan">1</xsl:attribute>
					<xsl:attribute name="data-attrvalue-rowspan">1</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="br | a | p | b | strong | i | u | span | text() | ./*[not(self::a | self::p | self::b | self::strong | self::i | self::u | self::span)]//text()"/>
		</td>
	</xsl:template>

	<!-- text -->
	<xsl:template match="body/text()">
		<xsl:if test="normalize-space(.) != '' or preceding-sibling::node() or following-sibling::node()">
			<div data-type="p">
				<span data-type="text"><xsl:value-of select="."/></span>
			</div>
		</xsl:if>
	</xsl:template>

	<xsl:template match="body//text()">
		<xsl:if test="normalize-space(.) != '' or preceding-sibling::node() or following-sibling::node()">
			<span data-type="text"><xsl:value-of select="."/></span>
		</xsl:if>
	</xsl:template>

	<!-- ignore all elements with @xe-ignore -->
	<xsl:template match="*[@xe-ignore='true']" priority="9"></xsl:template>
</xsl:stylesheet>